/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.clipboard;

import com.mojang.blaze3d.systems.RenderSystem;
import com.moulberry.axiom.Axiom;
import com.moulberry.axiom.ServerConfig;
import com.moulberry.axiom.VersionUtils;
import com.moulberry.axiom.clipboard.SelectionHistoryElement;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.render.EffectRenderer;
import com.moulberry.axiom.render.MeshDataHelper;
import com.moulberry.axiom.render.Shapes;
import com.moulberry.axiom.render.VertexConsumerProvider;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.render.regions.ChunkedBooleanRegion;
import com.moulberry.axiom.utils.IntWrapper;
import com.moulberry.axiom.world_modification.BlockBuffer;
import com.moulberry.axiom.world_modification.BlockOrBiomeBuffer;
import com.moulberry.axiom.world_modification.ClientBlockEntitySerializer;
import com.moulberry.axiom.world_modification.CompressedBlockEntity;
import com.moulberry.axiom.world_modification.Dispatcher;
import com.moulberry.axiom.world_modification.HistoryEntry;
import com.moulberry.axiomclientapi.funcinterfaces.TriIntConsumer;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.ByteArrayOutputStream;
import java.text.NumberFormat;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.UnaryOperator;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2841;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_7225;
import net.minecraft.class_757;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public interface SelectionBuffer {
    public static final Empty EMPTY = new Empty();

    public int size();

    @Nullable
    public class_2338 center();

    @Nullable
    public class_2338 min();

    @Nullable
    public class_2338 max();

    public SelectionHistoryElement createHistoryElement();

    public SelectionBuffer optimize();

    public boolean contains(int var1, int var2, int var3);

    public boolean isEmpty();

    public SelectionBuffer modify(UnaryOperator<ChunkedBooleanRegion> var1, boolean var2);

    public SelectionBuffer addAABB(class_2338 var1, class_2338 var2, boolean var3);

    public SelectionBuffer subtractAABB(class_2338 var1, class_2338 var2, boolean var3);

    public SelectionBuffer intersectAABB(class_2338 var1, class_2338 var2, boolean var3);

    public SelectionBuffer addSet(PositionSet var1, boolean var2);

    public SelectionBuffer subtractSet(PositionSet var1, boolean var2);

    public SelectionBuffer intersectSet(PositionSet var1, boolean var2);

    public SelectionBuffer move(int var1, int var2, int var3, boolean var4);

    public void callDelete();

    public CompletableFuture<CopyResult> callCopy(boolean var1, boolean var2);

    public void forEach(TriIntConsumer var1);

    public void render(class_4184 var1, long var2, class_4587 var4, Matrix4f var5, int var6);

    default public void close() {
    }

    default public void pushActiveSelectionHistory(class_2338 oldCenter, int oldCount, SelectionHistoryElement oldElement) {
        int newCount = this.size();
        int selectionDelta = newCount - oldCount;
        SelectionHistoryElement newElement = this.createHistoryElement();
        String historyDescription = selectionDelta > 0 ? (oldCount == 0 ? AxiomI18n.get("axiom.history_description.selected", NumberFormat.getInstance().format(newCount)) : AxiomI18n.get("axiom.history_description.selected_additional", NumberFormat.getInstance().format(selectionDelta))) : (selectionDelta < 0 ? (newCount == 0 ? AxiomI18n.get("axiom.history_description.deselected_all") : AxiomI18n.get("axiom.history_description.deselected", NumberFormat.getInstance().format(-selectionDelta))) : AxiomI18n.get("axiom.history_description.selected", NumberFormat.getInstance().format(newCount)));
        class_2338 center = this.center();
        if (center == null) {
            if (oldCenter == null) {
                return;
            }
            center = oldCenter;
        }
        Dispatcher.pushActiveSelection(new HistoryEntry<SelectionHistoryElement>(newElement, oldElement, center, historyDescription, 0));
    }

    public static boolean addAABBToBooleanRegion(ChunkedBooleanRegion selectionRegion, class_2338 min2, class_2338 max2) {
        boolean changed = false;
        int minX = min2.method_10263();
        int minY = min2.method_10264();
        int minZ = min2.method_10260();
        int maxX = max2.method_10263();
        int maxY = max2.method_10264();
        int maxZ = max2.method_10260();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    changed |= selectionRegion.add(x, y, z);
                }
            }
        }
        return changed;
    }

    public static class Empty
    implements SelectionBuffer {
        @Override
        public int size() {
            return 0;
        }

        @Override
        @Nullable
        public class_2338 center() {
            return null;
        }

        @Override
        @Nullable
        public class_2338 min() {
            return null;
        }

        @Override
        @Nullable
        public class_2338 max() {
            return null;
        }

        @Override
        public SelectionHistoryElement createHistoryElement() {
            return SelectionHistoryElement.EMPTY;
        }

        @Override
        public boolean contains(int x, int y, int z) {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public SelectionBuffer modify(UnaryOperator<ChunkedBooleanRegion> consumer, boolean history) {
            return new Set(new ChunkedBooleanRegion()).modify(consumer, history);
        }

        @Override
        public SelectionBuffer addAABB(class_2338 min2, class_2338 max2, boolean history) {
            AABB buffer = new AABB(min2, max2);
            if (history) {
                buffer.pushActiveSelectionHistory(null, 0, SelectionHistoryElement.EMPTY);
            }
            return buffer;
        }

        @Override
        public SelectionBuffer subtractAABB(class_2338 min2, class_2338 max2, boolean history) {
            return this;
        }

        @Override
        public SelectionBuffer intersectAABB(class_2338 min2, class_2338 max2, boolean history) {
            return this;
        }

        @Override
        public SelectionBuffer addSet(PositionSet set, boolean history) {
            Set buffer = new Set(new ChunkedBooleanRegion(set));
            if (history) {
                buffer.pushActiveSelectionHistory(null, 0, SelectionHistoryElement.EMPTY);
            }
            return buffer;
        }

        @Override
        public SelectionBuffer subtractSet(PositionSet set, boolean history) {
            return this;
        }

        @Override
        public SelectionBuffer intersectSet(PositionSet set, boolean history) {
            return this;
        }

        @Override
        public SelectionBuffer move(int x, int y, int z, boolean history) {
            return this;
        }

        @Override
        public void callDelete() {
        }

        @Override
        public CompletableFuture<CopyResult> callCopy(boolean cut, boolean copyAir) {
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public void forEach(TriIntConsumer consumer) {
        }

        @Override
        public void render(class_4184 camera, long time, class_4587 matrices, Matrix4f projection, int effects) {
        }

        @Override
        public SelectionBuffer optimize() {
            return this;
        }
    }

    public record AABB(class_2338 min, class_2338 max) implements SelectionBuffer
    {
        public AABB {
            if (min2.method_10263() > max2.method_10263() || min2.method_10264() > max2.method_10264() || min2.method_10260() > max2.method_10260()) {
                int minX = Math.min(min2.method_10263(), max2.method_10263());
                int minY = Math.min(min2.method_10264(), max2.method_10264());
                int minZ = Math.min(min2.method_10260(), max2.method_10260());
                int maxX = Math.max(min2.method_10263(), max2.method_10263());
                int maxY = Math.max(min2.method_10264(), max2.method_10264());
                int maxZ = Math.max(min2.method_10260(), max2.method_10260());
                min2 = new class_2338(minX, minY, minZ);
                max2 = new class_2338(maxX, maxY, maxZ);
            } else {
                min2 = min2.method_10062();
                max2 = max2.method_10062();
            }
        }

        @Override
        public int size() {
            return (this.max.method_10263() - this.min.method_10263() + 1) * (this.max.method_10264() - this.min.method_10264() + 1) * (this.max.method_10260() - this.min.method_10260() + 1);
        }

        @Override
        public class_2338 center() {
            return new class_2338(Math.floorDiv(this.max.method_10263() + this.min.method_10263(), 2), Math.floorDiv(this.max.method_10264() + this.min.method_10264(), 2), Math.floorDiv(this.max.method_10260() + this.min.method_10260(), 2));
        }

        @Override
        public SelectionHistoryElement createHistoryElement() {
            return new SelectionHistoryElement.AABB(this.min, this.max);
        }

        @Override
        public boolean contains(int x, int y, int z) {
            return x >= this.min.method_10263() && x <= this.max.method_10263() && y >= this.min.method_10264() && y <= this.max.method_10264() && z >= this.min.method_10260() && z <= this.max.method_10260();
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public SelectionBuffer modify(UnaryOperator<ChunkedBooleanRegion> consumer, boolean history) {
            ChunkedBooleanRegion selectionRegion = new ChunkedBooleanRegion();
            SelectionBuffer.addAABBToBooleanRegion(selectionRegion, this.min, this.max);
            return new Set(selectionRegion).modify(consumer, history);
        }

        @Override
        public SelectionBuffer addAABB(class_2338 min2, class_2338 max2, boolean history) {
            if (AABB.aabbCompletelyOverlapsAabb(this.min, this.max, min2, max2)) {
                return this;
            }
            if (AABB.aabbCompletelyOverlapsAabb(min2, max2, this.min, this.max)) {
                AABB buffer = new AABB(min2, max2);
                if (history) {
                    buffer.pushActiveSelectionHistory(this.center(), this.size(), this.createHistoryElement());
                }
                return buffer;
            }
            if (min2.method_10263() == this.min.method_10263() && max2.method_10263() == this.max.method_10263()) {
                if (min2.method_10264() == this.min.method_10264() && max2.method_10264() == this.max.method_10264()) {
                    if (AABB.areLineSegmentsContinuous(min2.method_10260(), max2.method_10260(), this.min.method_10260(), this.max.method_10260())) {
                        AABB buffer = new AABB(new class_2338(min2.method_10263(), min2.method_10264(), Math.min(min2.method_10260(), this.min.method_10260())), new class_2338(max2.method_10263(), max2.method_10264(), Math.max(max2.method_10260(), this.max.method_10260())));
                        if (history) {
                            buffer.pushActiveSelectionHistory(this.center(), this.size(), this.createHistoryElement());
                        }
                        return buffer;
                    }
                } else if (min2.method_10260() == this.min.method_10260() && max2.method_10260() == this.max.method_10260() && AABB.areLineSegmentsContinuous(min2.method_10264(), max2.method_10264(), this.min.method_10264(), this.max.method_10264())) {
                    AABB buffer = new AABB(new class_2338(min2.method_10263(), Math.min(min2.method_10264(), this.min.method_10264()), min2.method_10260()), new class_2338(max2.method_10263(), Math.max(max2.method_10264(), this.max.method_10264()), max2.method_10260()));
                    if (history) {
                        buffer.pushActiveSelectionHistory(this.center(), this.size(), this.createHistoryElement());
                    }
                    return buffer;
                }
            } else if (min2.method_10264() == this.min.method_10264() && max2.method_10264() == this.max.method_10264() && min2.method_10260() == this.min.method_10260() && max2.method_10260() == this.max.method_10260() && AABB.areLineSegmentsContinuous(min2.method_10263(), max2.method_10263(), this.min.method_10263(), this.max.method_10263())) {
                AABB buffer = new AABB(new class_2338(Math.min(min2.method_10263(), this.min.method_10263()), min2.method_10264(), min2.method_10260()), new class_2338(Math.max(max2.method_10263(), this.max.method_10263()), max2.method_10264(), max2.method_10260()));
                if (history) {
                    buffer.pushActiveSelectionHistory(this.center(), this.size(), this.createHistoryElement());
                }
                return buffer;
            }
            ChunkedBooleanRegion selectionRegion = new ChunkedBooleanRegion();
            SelectionBuffer.addAABBToBooleanRegion(selectionRegion, this.min, this.max);
            return new Set(selectionRegion).addAABB(min2, max2, history);
        }

        @Override
        public SelectionBuffer subtractAABB(class_2338 min2, class_2338 max2, boolean history) {
            SelectionHistoryElement oldElement;
            boolean completelyOverlapZ;
            if (!AABB.lineSegmentsIntersect(min2.method_10263(), max2.method_10263(), this.min.method_10263(), this.max.method_10263())) {
                return this;
            }
            if (!AABB.lineSegmentsIntersect(min2.method_10264(), max2.method_10264(), this.min.method_10264(), this.max.method_10264())) {
                return this;
            }
            if (!AABB.lineSegmentsIntersect(min2.method_10260(), max2.method_10260(), this.min.method_10260(), this.max.method_10260())) {
                return this;
            }
            boolean overlapsMinX = min2.method_10263() <= this.min.method_10263();
            boolean overlapsMaxX = max2.method_10263() >= this.max.method_10263();
            boolean completelyOverlapX = overlapsMinX && overlapsMaxX;
            boolean overlapsMinY = min2.method_10264() <= this.min.method_10264();
            boolean overlapsMaxY = max2.method_10264() >= this.max.method_10264();
            boolean completelyOverlapY = overlapsMinY && overlapsMaxY;
            boolean overlapsMinZ = min2.method_10260() <= this.min.method_10260();
            boolean overlapsMaxZ = max2.method_10260() >= this.max.method_10260();
            boolean bl = completelyOverlapZ = overlapsMinZ && overlapsMaxZ;
            if (completelyOverlapX && completelyOverlapY && completelyOverlapZ) {
                if (history) {
                    Dispatcher.clearActiveSelectionHistory();
                }
                return EMPTY;
            }
            class_2338 oldCenter = this.center();
            int oldCount = this.size();
            SelectionHistoryElement selectionHistoryElement = oldElement = history ? this.createHistoryElement() : null;
            if ((overlapsMinX || overlapsMaxX) && completelyOverlapY && completelyOverlapZ) {
                int minX = this.min.method_10263();
                int maxX = this.max.method_10263();
                if (overlapsMinX) {
                    minX = max2.method_10263() + 1;
                } else {
                    maxX = min2.method_10263() - 1;
                }
                AABB buffer = new AABB(new class_2338(minX, this.min.method_10264(), this.min.method_10260()), new class_2338(maxX, this.max.method_10264(), this.max.method_10260()));
                if (history) {
                    buffer.pushActiveSelectionHistory(oldCenter, oldCount, oldElement);
                }
                return buffer;
            }
            if (completelyOverlapX && (overlapsMinY || overlapsMaxY) && completelyOverlapZ) {
                int minY = this.min.method_10264();
                int maxY = this.max.method_10264();
                if (overlapsMinY) {
                    minY = max2.method_10264() + 1;
                } else {
                    maxY = min2.method_10264() - 1;
                }
                AABB buffer = new AABB(new class_2338(this.min.method_10263(), minY, this.min.method_10260()), new class_2338(this.max.method_10263(), maxY, this.max.method_10260()));
                if (history) {
                    buffer.pushActiveSelectionHistory(oldCenter, oldCount, oldElement);
                }
                return buffer;
            }
            if (completelyOverlapX && completelyOverlapY && (overlapsMinZ || overlapsMaxZ)) {
                int minZ = this.min.method_10260();
                int maxZ = this.max.method_10260();
                if (overlapsMinZ) {
                    minZ = max2.method_10260() + 1;
                } else {
                    maxZ = min2.method_10260() - 1;
                }
                AABB buffer = new AABB(new class_2338(this.min.method_10263(), this.min.method_10264(), minZ), new class_2338(this.max.method_10263(), this.max.method_10264(), maxZ));
                if (history) {
                    buffer.pushActiveSelectionHistory(oldCenter, oldCount, oldElement);
                }
                return buffer;
            }
            ChunkedBooleanRegion selectionRegion = new ChunkedBooleanRegion();
            SelectionBuffer.addAABBToBooleanRegion(selectionRegion, this.min, this.max);
            return new Set(selectionRegion).subtractAABB(min2, max2, history);
        }

        @Override
        public SelectionBuffer intersectAABB(class_2338 min2, class_2338 max2, boolean history) {
            class_2338 oldCenter = this.center();
            int oldCount = this.size();
            SelectionHistoryElement oldElement = history ? this.createHistoryElement() : null;
            int minX = Math.max(min2.method_10263(), this.min.method_10263());
            int minY = Math.max(min2.method_10264(), this.min.method_10264());
            int minZ = Math.max(min2.method_10260(), this.min.method_10260());
            int maxX = Math.min(max2.method_10263(), this.max.method_10263());
            int maxY = Math.min(max2.method_10264(), this.max.method_10264());
            int maxZ = Math.min(max2.method_10260(), this.max.method_10260());
            if (minX > maxX || minY > maxY || minZ > maxZ) {
                if (history) {
                    Dispatcher.clearActiveSelectionHistory();
                }
                return EMPTY;
            }
            AABB buffer = new AABB(new class_2338(minX, minY, minZ), new class_2338(maxX, maxY, maxZ));
            if (history) {
                buffer.pushActiveSelectionHistory(oldCenter, oldCount, oldElement);
            }
            return buffer;
        }

        @Override
        public SelectionBuffer addSet(PositionSet set, boolean history) {
            ChunkedBooleanRegion selectionRegion = new ChunkedBooleanRegion();
            SelectionBuffer.addAABBToBooleanRegion(selectionRegion, this.min, this.max);
            return new Set(selectionRegion).addSet(set, history);
        }

        @Override
        public SelectionBuffer subtractSet(PositionSet set, boolean history) {
            class_2338 oldCenter = this.center();
            int oldCount = this.size();
            SelectionHistoryElement oldElement = history ? this.createHistoryElement() : null;
            ChunkedBooleanRegion region = new ChunkedBooleanRegion();
            int minX = this.min.method_10263();
            int minY = this.min.method_10264();
            int minZ = this.min.method_10260();
            int maxX = this.max.method_10263();
            int maxY = this.max.method_10264();
            int maxZ = this.max.method_10260();
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        if (set.contains(x, y, z)) continue;
                        region.add(x, y, z);
                    }
                }
            }
            SelectionBuffer buffer = new Set(region).optimize();
            if (history) {
                buffer.pushActiveSelectionHistory(oldCenter, oldCount, oldElement);
            }
            return buffer;
        }

        @Override
        public SelectionBuffer intersectSet(PositionSet set, boolean history) {
            class_2338 oldCenter = this.center();
            int oldCount = this.size();
            SelectionHistoryElement oldElement = history ? this.createHistoryElement() : null;
            ChunkedBooleanRegion region = new ChunkedBooleanRegion();
            int minX = this.min.method_10263();
            int minY = this.min.method_10264();
            int minZ = this.min.method_10260();
            int maxX = this.max.method_10263();
            int maxY = this.max.method_10264();
            int maxZ = this.max.method_10260();
            for (int x = minX; x <= maxX; ++x) {
                for (int y = minY; y <= maxY; ++y) {
                    for (int z = minZ; z <= maxZ; ++z) {
                        if (!set.contains(x, y, z)) continue;
                        region.add(x, y, z);
                    }
                }
            }
            SelectionBuffer buffer = new Set(region).optimize();
            if (history) {
                buffer.pushActiveSelectionHistory(oldCenter, oldCount, oldElement);
            }
            return buffer;
        }

        @Override
        public SelectionBuffer move(int x, int y, int z, boolean history) {
            class_2338 oldCenter = this.center();
            int oldCount = this.size();
            SelectionHistoryElement oldElement = history ? this.createHistoryElement() : null;
            AABB buffer = new AABB(this.min.method_10069(x, y, z), this.max.method_10069(x, y, z));
            if (history) {
                buffer.pushActiveSelectionHistory(oldCenter, oldCount, oldElement);
            }
            return buffer;
        }

        @Override
        public void callDelete() {
            class_638 world = class_310.method_1551().field_1687;
            if (world == null) {
                return;
            }
            BlockBuffer setOperation = new BlockBuffer();
            BlockBuffer previousBlocksForUndo = new BlockBuffer();
            class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
            int changeCount = 0;
            class_2680 air = class_2246.field_10124.method_9564();
            for (int x = this.min.method_10263(); x <= this.max.method_10263(); ++x) {
                for (int y = this.min.method_10264(); y <= this.max.method_10264(); ++y) {
                    for (int z = this.min.method_10260(); z <= this.max.method_10260(); ++z) {
                        class_2680 block = world.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
                        if (block.method_26215()) continue;
                        setOperation.set(x, y, z, air);
                        previousBlocksForUndo.set(x, y, z, block);
                        ++changeCount;
                    }
                }
            }
            String countString = NumberFormat.getInstance().format(changeCount);
            String historyDescription = AxiomI18n.get("axiom.history_description.deleted", countString);
            Dispatcher.push(new HistoryEntry<BlockOrBiomeBuffer>(setOperation, previousBlocksForUndo, this.center(), historyDescription, HistoryEntry.MODIFIER_SELECT_ON_BACKSTEP), Dispatcher.simpleSourceInfo("Selection Delete"));
        }

        @Override
        public CompletableFuture<CopyResult> callCopy(boolean cut, boolean copyAir) {
            class_638 world = class_310.method_1551().field_1687;
            if (world == null) {
                return CompletableFuture.completedFuture(null);
            }
            class_2338 offset = this.center();
            BlockBuffer forwards = cut ? new BlockBuffer() : null;
            BlockBuffer backwards = cut ? new BlockBuffer() : null;
            IntWrapper changeCount = cut ? new IntWrapper() : null;
            class_2680 air = class_2246.field_10124.method_9564();
            LongOpenHashSet needNbt = new LongOpenHashSet();
            LongOpenHashSet needChunks = new LongOpenHashSet();
            ChunkedBlockRegion blockBuffer = new ChunkedBlockRegion();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Long2ObjectOpenHashMap loadedNbt = new Long2ObjectOpenHashMap();
            class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
            int minSectionX = this.min.method_10263() >> 4;
            int minSectionY = Math.max(world.method_32891(), this.min.method_10264() >> 4);
            int minSectionZ = this.min.method_10260() >> 4;
            int maxSectionX = this.max.method_10263() >> 4;
            int maxSectionY = Math.min(world.method_31597() - 1, this.max.method_10264() >> 4);
            int maxSectionZ = this.max.method_10260() >> 4;
            ServerConfig serverConfig = Axiom.getInstance().serverConfig;
            for (int sx = minSectionX; sx <= maxSectionX; ++sx) {
                for (int sz = minSectionZ; sz <= maxSectionZ; ++sz) {
                    int sy;
                    class_2818 chunk = (class_2818)world.method_8402(sx, sz, class_2806.field_12803, false);
                    if (chunk == null) {
                        for (sy = minSectionY; sy <= maxSectionY; ++sy) {
                            needChunks.add(class_2338.method_10064((int)sx, (int)sy, (int)sz));
                        }
                        continue;
                    }
                    for (sy = minSectionY; sy <= maxSectionY; ++sy) {
                        class_2826 section = chunk.method_38259(chunk.method_31603(sy));
                        if (section.method_38292()) continue;
                        int lx = Math.max(0, this.min.method_10263() - sx * 16);
                        int ux = Math.min(15, this.max.method_10263() - sx * 16);
                        int ly = Math.max(0, this.min.method_10264() - sy * 16);
                        int uy = Math.min(15, this.max.method_10264() - sy * 16);
                        int lz = Math.max(0, this.min.method_10260() - sz * 16);
                        int uz = Math.min(15, this.max.method_10260() - sz * 16);
                        class_2841 container = section.method_12265();
                        for (int x = lx; x <= ux; ++x) {
                            for (int y = ly; y <= uy; ++y) {
                                for (int z = lz; z <= uz; ++z) {
                                    class_2680 blockState = (class_2680)container.method_12321(x, y, z);
                                    if (!copyAir && blockState.method_26215()) continue;
                                    if (cut) {
                                        forwards.set(x + sx * 16, y + sy * 16, z + sz * 16, air);
                                        backwards.set(x + sx * 16, y + sy * 16, z + sz * 16, blockState);
                                        ++changeCount.value;
                                    }
                                    blockBuffer.addBlock(x + sx * 16 - offset.method_10263(), y + sy * 16 - offset.method_10264(), z + sz * 16 - offset.method_10260(), blockState);
                                    if (serverConfig.blocksWithCustomData().contains(blockState.method_26204())) {
                                        needNbt.add(class_2338.method_10064((int)(x + sx * 16), (int)(y + sy * 16), (int)(z + sz * 16)));
                                        continue;
                                    }
                                    if (!blockState.method_31709()) continue;
                                    mutableBlockPos.method_10103(x + sx * 16, y + sy * 16, z + sz * 16);
                                    class_2586 blockEntity = chunk.method_12201((class_2338)mutableBlockPos, class_2818.class_2819.field_12859);
                                    if (blockEntity == null) continue;
                                    class_2487 nbt = ClientBlockEntitySerializer.serialize(blockEntity, (class_7225.class_7874)world.method_30349());
                                    if (nbt != null) {
                                        if (nbt.method_33133()) continue;
                                        CompressedBlockEntity compressedBlockEntity = CompressedBlockEntity.compress(nbt, baos);
                                        long pos = class_2338.method_10064((int)(x + sx * 16 - offset.method_10263()), (int)(y + sy * 16 - offset.method_10264()), (int)(z + sz * 16 - offset.method_10260()));
                                        if (cut) {
                                            backwards.putBlockEntity(x + sx * 16, y + sy * 16, z + sz * 16, compressedBlockEntity);
                                        }
                                        loadedNbt.put(pos, (Object)compressedBlockEntity);
                                        continue;
                                    }
                                    needNbt.add(mutableBlockPos.method_10063());
                                }
                            }
                        }
                    }
                }
            }
            if (needNbt.isEmpty() && needChunks.isEmpty()) {
                if (cut) {
                    String countString = NumberFormat.getInstance().format(changeCount.value);
                    String historyDescription = AxiomI18n.get("axiom.history_description.cut", countString);
                    Dispatcher.push(new HistoryEntry<BlockOrBiomeBuffer>(forwards, backwards, offset, historyDescription, HistoryEntry.MODIFIER_CUT | HistoryEntry.MODIFIER_SELECT_ON_BACKSTEP), Dispatcher.simpleSourceInfo("Selection Cut"));
                }
                return CompletableFuture.completedFuture(new CopyResult(blockBuffer, (Long2ObjectMap<CompressedBlockEntity>)loadedNbt));
            }
            CompletableFuture<CopyResult> future = new CompletableFuture<CopyResult>();
            int minX = this.min.method_10263();
            int minY = this.min.method_10264();
            int minZ = this.min.method_10260();
            int maxX = this.max.method_10263();
            int maxY = this.max.method_10264();
            int maxZ = this.max.method_10260();
            Dispatcher.requestChunkData((LongSet)needNbt, (LongSet)needChunks, true, (arg_0, arg_1) -> AABB.lambda$callCopy$2(minX, maxX, minY, maxY, minZ, maxZ, copyAir, cut, forwards, air, backwards, changeCount, blockBuffer, offset, (Long2ObjectMap)loadedNbt, future, arg_0, arg_1));
            return future;
        }

        @Override
        public void forEach(TriIntConsumer consumer) {
            for (int x = this.min.method_10263(); x <= this.max.method_10263(); ++x) {
                for (int y = this.min.method_10264(); y <= this.max.method_10264(); ++y) {
                    for (int z = this.min.method_10260(); z <= this.max.method_10260(); ++z) {
                        consumer.accept(x, y, z);
                    }
                }
            }
        }

        @Override
        public void render(class_4184 camera, long time, class_4587 matrices, Matrix4f projection, int effects) {
            VertexConsumerProvider provider = VertexConsumerProvider.shared();
            float minX = (float)this.min.method_10263() - 1.0E-4f;
            float minY = (float)this.min.method_10264() - 1.0E-4f;
            float minZ = (float)this.min.method_10260() - 1.0E-4f;
            float maxX = (float)(this.max.method_10263() + 1) + 1.0E-4f;
            float maxY = (float)(this.max.method_10264() + 1) + 1.0E-4f;
            float maxZ = (float)(this.max.method_10260() + 1) + 1.0E-4f;
            matrices.method_22903();
            matrices.method_22904(-camera.method_19326().field_1352, -camera.method_19326().field_1351, -camera.method_19326().field_1350);
            RenderSystem.applyModelViewMatrix();
            matrices.method_46416(minX, minY, minZ);
            if ((effects & 4) != 0) {
                RenderSystem.setShaderColor((float)1.0f, (float)0.9f, (float)0.12f, (float)1.0f);
                RenderSystem.enableBlend();
                RenderSystem.lineWidth((float)2.0f);
                RenderSystem.disableCull();
                RenderSystem.depthMask((boolean)false);
                RenderSystem.setShader(class_757::method_34535);
                RenderSystem.enableDepthTest();
                class_287 bufferBuilder = provider.begin(class_293.class_5596.field_27377, class_290.field_29337);
                Shapes.lineBox(matrices, (class_4588)bufferBuilder, 0.0f, 0.0f, 0.0f, maxX - minX, maxY - minY, maxZ - minZ, 1.0f, 1.0f, 1.0f, 0.5f, 1.0f, 1.0f, 1.0f);
                MeshDataHelper.drawWithShader(VersionUtils.helperOldBufferBuilderEndOrDiscard(bufferBuilder));
                RenderSystem.disableDepthTest();
                bufferBuilder = provider.begin(class_293.class_5596.field_27377, class_290.field_29337);
                Shapes.lineBox(matrices, (class_4588)bufferBuilder, 0.0f, 0.0f, 0.0f, maxX - minX, maxY - minY, maxZ - minZ, 1.0f, 1.0f, 1.0f, 0.15f, 1.0f, 1.0f, 1.0f);
                MeshDataHelper.drawWithShader(VersionUtils.helperOldBufferBuilderEndOrDiscard(bufferBuilder));
                RenderSystem.depthMask((boolean)true);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            RenderSystem.setShader(class_757::method_34540);
            EffectRenderer.render(() -> {
                Shapes.shadedBox(provider, matrices.method_23760().method_23761(), maxX - minX, maxY - minY, maxZ - minZ, -1);
                MeshDataHelper.drawWithShader(provider.build());
            }, time, effects & 0xFFFFFFFB);
            matrices.method_22909();
        }

        @Override
        public SelectionBuffer optimize() {
            if (this.min.method_10263() > this.max.method_10263()) {
                this.close();
                return EMPTY;
            }
            if (this.min.method_10264() > this.max.method_10264()) {
                this.close();
                return EMPTY;
            }
            if (this.min.method_10260() > this.max.method_10260()) {
                this.close();
                return EMPTY;
            }
            return this;
        }

        private static boolean aabbCompletelyOverlapsAabb(class_2338 min1, class_2338 max1, class_2338 min2, class_2338 max2) {
            return min1.method_10263() <= min2.method_10263() && min1.method_10264() <= min2.method_10264() && min1.method_10260() <= min2.method_10260() && max1.method_10263() >= max2.method_10263() && max1.method_10264() >= max2.method_10264() && max1.method_10260() >= max2.method_10260();
        }

        private static boolean areLineSegmentsContinuous(int min1, int max1, int min2, int max2) {
            int size1 = max1 - min1 + 1;
            int size2 = max2 - min2 + 1;
            float mid1 = min1 + max1;
            float mid2 = min2 + max2;
            float midDiff = Math.abs(mid1 - mid2);
            return midDiff <= (float)(size1 + size2);
        }

        private static boolean lineSegmentsIntersect(int min1, int max1, int min2, int max2) {
            int size1 = max1 - min1 + 1;
            int size2 = max2 - min2 + 1;
            float mid1 = min1 + max1;
            float mid2 = min2 + max2;
            float midDiff = Math.abs(mid1 - mid2);
            return midDiff < (float)(size1 + size2);
        }

        private static /* synthetic */ void lambda$callCopy$2(int minX, int maxX, int minY, int maxY, int minZ, int maxZ, boolean copyAir, boolean cut, BlockBuffer forwards, class_2680 air, BlockBuffer backwards, IntWrapper changeCount, ChunkedBlockRegion blockBuffer, class_2338 offset, Long2ObjectMap loadedNbt, CompletableFuture future, Long2ObjectMap compressedBlockEntities, Long2ObjectMap chunkSections) {
            chunkSections.forEach((pos, container) -> {
                if (container == null) {
                    return;
                }
                int sx = class_2338.method_10061((long)pos);
                int sy = class_2338.method_10071((long)pos);
                int sz = class_2338.method_10083((long)pos);
                int lx = Math.max(0, minX - sx * 16);
                int ux = Math.min(15, maxX - sx * 16);
                int ly = Math.max(0, minY - sy * 16);
                int uy = Math.min(15, maxY - sy * 16);
                int lz = Math.max(0, minZ - sz * 16);
                int uz = Math.min(15, maxZ - sz * 16);
                for (int x = lx; x <= ux; ++x) {
                    for (int y = ly; y <= uy; ++y) {
                        for (int z = lz; z <= uz; ++z) {
                            class_2680 blockState = (class_2680)container.method_12321(x, y, z);
                            if (!copyAir && blockState.method_26215()) continue;
                            if (cut) {
                                forwards.set(x + sx * 16, y + sy * 16, z + sz * 16, air);
                                backwards.set(x + sx * 16, y + sy * 16, z + sz * 16, blockState);
                                ++changeCount.value;
                            }
                            blockBuffer.addBlock(x + sx * 16 - offset.method_10263(), y + sy * 16 - offset.method_10264(), z + sz * 16 - offset.method_10260(), blockState);
                        }
                    }
                }
            });
            compressedBlockEntities.forEach((pos, compressedBlockEntity) -> {
                int x = class_2338.method_10061((long)pos);
                int y = class_2338.method_10071((long)pos);
                int z = class_2338.method_10083((long)pos);
                int xo = x - offset.method_10263();
                int yo = y - offset.method_10264();
                int zo = z - offset.method_10260();
                if (cut) {
                    backwards.putBlockEntity(x, y, z, (CompressedBlockEntity)compressedBlockEntity);
                }
                loadedNbt.put(class_2338.method_10064((int)xo, (int)yo, (int)zo), compressedBlockEntity);
            });
            if (cut) {
                String countString = NumberFormat.getInstance().format(changeCount.value);
                String historyDescription = AxiomI18n.get("axiom.history_description.cut", countString);
                Dispatcher.push(new HistoryEntry<BlockOrBiomeBuffer>(forwards, backwards, offset, historyDescription, HistoryEntry.MODIFIER_CUT | HistoryEntry.MODIFIER_SELECT_ON_BACKSTEP), Dispatcher.simpleSourceInfo("Selection Cut"));
            }
            future.complete(new CopyResult(blockBuffer, (Long2ObjectMap<CompressedBlockEntity>)loadedNbt));
        }
    }

    public static final class Set
    implements SelectionBuffer {
        public ChunkedBooleanRegion selectionRegion;
        private SelectionHistoryElement cachedHistoryElement = null;

        public Set(ChunkedBooleanRegion selectionRegion) {
            this.selectionRegion = selectionRegion;
        }

        @Override
        public void close() {
            if (this.selectionRegion != null) {
                this.selectionRegion.close();
                this.selectionRegion = null;
            }
        }

        @Override
        public int size() {
            return this.selectionRegion.count();
        }

        @Override
        @NotNull
        public class_2338 center() {
            return this.selectionRegion.getCenter();
        }

        @Override
        @Nullable
        public class_2338 min() {
            return this.selectionRegion.min();
        }

        @Override
        @Nullable
        public class_2338 max() {
            return this.selectionRegion.max();
        }

        @Override
        public SelectionHistoryElement createHistoryElement() {
            if (this.cachedHistoryElement == null) {
                this.cachedHistoryElement = new SelectionHistoryElement.Set(this.selectionRegion.copyPositionSet());
            }
            return this.cachedHistoryElement;
        }

        @Override
        public boolean contains(int x, int y, int z) {
            return this.selectionRegion.contains(x, y, z);
        }

        @Override
        public boolean isEmpty() {
            assert (this.selectionRegion.count() > 0);
            return false;
        }

        @Override
        public SelectionBuffer modify(UnaryOperator<ChunkedBooleanRegion> consumer, boolean history) {
            class_2338 oldCenter = this.center();
            int oldCount = this.size();
            SelectionHistoryElement oldElement = history ? this.createHistoryElement() : null;
            this.cachedHistoryElement = null;
            ChunkedBooleanRegion chunkedBooleanRegion = (ChunkedBooleanRegion)consumer.apply(this.selectionRegion);
            if (chunkedBooleanRegion != this.selectionRegion) {
                this.selectionRegion.close();
                this.selectionRegion = chunkedBooleanRegion;
            }
            if (this.selectionRegion.count() == 0) {
                if (history) {
                    Dispatcher.clearActiveSelectionHistory();
                }
                this.close();
                return EMPTY;
            }
            SelectionBuffer buffer = this.optimize();
            if (history) {
                buffer.pushActiveSelectionHistory(oldCenter, oldCount, oldElement);
            }
            return buffer;
        }

        @Override
        public SelectionBuffer addAABB(class_2338 min2, class_2338 max2, boolean history) {
            SelectionBuffer buffer;
            SelectionHistoryElement oldElement;
            class_2338 oldCenter = this.center();
            int oldCount = this.size();
            SelectionHistoryElement selectionHistoryElement = oldElement = history ? this.createHistoryElement() : null;
            if (min2.method_10263() <= this.selectionRegion.min().method_10263() && min2.method_10264() <= this.selectionRegion.min().method_10264() && min2.method_10260() <= this.selectionRegion.min().method_10260() && max2.method_10263() >= this.selectionRegion.max().method_10263() && max2.method_10264() >= this.selectionRegion.max().method_10264() && max2.method_10260() >= this.selectionRegion.max().method_10260()) {
                this.close();
                buffer = new AABB(min2, max2);
            } else {
                if (!SelectionBuffer.addAABBToBooleanRegion(this.selectionRegion, min2, max2)) {
                    return this;
                }
                this.cachedHistoryElement = null;
                buffer = this.optimize();
            }
            if (history) {
                buffer.pushActiveSelectionHistory(oldCenter, oldCount, oldElement);
            }
            return buffer;
        }

        @Override
        public SelectionBuffer subtractAABB(class_2338 min2, class_2338 max2, boolean history) {
            SelectionHistoryElement oldElement;
            class_2338 oldCenter = this.center();
            int oldCount = this.size();
            SelectionHistoryElement selectionHistoryElement = oldElement = history ? this.createHistoryElement() : null;
            if (!this.selectionRegion.subtractAABB(min2, max2)) {
                return this;
            }
            this.cachedHistoryElement = null;
            if (this.selectionRegion.count() == 0) {
                if (history) {
                    Dispatcher.clearActiveSelectionHistory();
                }
                this.close();
                return EMPTY;
            }
            SelectionBuffer buffer = this.optimize();
            if (history) {
                buffer.pushActiveSelectionHistory(oldCenter, oldCount, oldElement);
            }
            return buffer;
        }

        @Override
        public SelectionBuffer intersectAABB(class_2338 min2, class_2338 max2, boolean history) {
            SelectionHistoryElement oldElement;
            class_2338 oldCenter = this.center();
            int oldCount = this.size();
            SelectionHistoryElement selectionHistoryElement = oldElement = history ? this.createHistoryElement() : null;
            if (!this.selectionRegion.intersectAABB(min2, max2)) {
                return this;
            }
            this.cachedHistoryElement = null;
            if (this.selectionRegion.count() == 0) {
                if (history) {
                    Dispatcher.clearActiveSelectionHistory();
                }
                this.close();
                return EMPTY;
            }
            SelectionBuffer buffer = this.optimize();
            if (history) {
                buffer.pushActiveSelectionHistory(oldCenter, oldCount, oldElement);
            }
            return buffer;
        }

        @Override
        public SelectionBuffer addSet(PositionSet set, boolean history) {
            class_2338 oldCenter = this.center();
            int oldCount = this.size();
            SelectionHistoryElement oldElement = history ? this.createHistoryElement() : null;
            this.cachedHistoryElement = null;
            set.forEach(this.selectionRegion::add);
            SelectionBuffer buffer = this.optimize();
            if (history) {
                buffer.pushActiveSelectionHistory(oldCenter, oldCount, oldElement);
            }
            return buffer;
        }

        @Override
        public SelectionBuffer subtractSet(PositionSet set, boolean history) {
            class_2338 oldCenter = this.center();
            int oldCount = this.size();
            SelectionHistoryElement oldElement = history ? this.createHistoryElement() : null;
            ChunkedBooleanRegion region = new ChunkedBooleanRegion();
            this.selectionRegion.forEach((x, y, z) -> {
                if (!set.contains(x, y, z)) {
                    region.add(x, y, z);
                }
            });
            SelectionBuffer buffer = new Set(region).optimize();
            if (history) {
                buffer.pushActiveSelectionHistory(oldCenter, oldCount, oldElement);
            }
            return buffer;
        }

        @Override
        public SelectionBuffer intersectSet(PositionSet set, boolean history) {
            class_2338 oldCenter = this.center();
            int oldCount = this.size();
            SelectionHistoryElement oldElement = history ? this.createHistoryElement() : null;
            ChunkedBooleanRegion region = new ChunkedBooleanRegion();
            if (set.count() < this.selectionRegion.count()) {
                set.forEach((x, y, z) -> {
                    if (this.selectionRegion.contains(x, y, z)) {
                        region.add(x, y, z);
                    }
                });
            } else {
                this.selectionRegion.forEach((x, y, z) -> {
                    if (set.contains(x, y, z)) {
                        region.add(x, y, z);
                    }
                });
            }
            SelectionBuffer buffer = new Set(region).optimize();
            if (history) {
                buffer.pushActiveSelectionHistory(oldCenter, oldCount, oldElement);
            }
            return buffer;
        }

        @Override
        public SelectionBuffer move(int x, int y, int z, boolean history) {
            class_2338 oldCenter = this.center();
            int oldCount = this.size();
            SelectionHistoryElement oldElement = history ? this.createHistoryElement() : null;
            ChunkedBooleanRegion region = new ChunkedBooleanRegion();
            this.forEach((x1, y1, z1) -> region.add(x + x1, y + y1, z + z1));
            SelectionBuffer buffer = new Set(region).optimize();
            if (history) {
                buffer.pushActiveSelectionHistory(oldCenter, oldCount, oldElement);
            }
            return buffer;
        }

        @Override
        public void callDelete() {
            class_638 world = class_310.method_1551().field_1687;
            if (world == null) {
                return;
            }
            BlockBuffer setOperation = new BlockBuffer();
            BlockBuffer previousBlocksForUndo = new BlockBuffer();
            AtomicInteger changeCount = new AtomicInteger();
            class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
            this.selectionRegion.forEach((x, y, z) -> {
                class_2680 block = world.method_8320((class_2338)mutableBlockPos.method_10103(x, y, z));
                if (!block.method_26215()) {
                    setOperation.set(x, y, z, class_2246.field_10124.method_9564());
                    previousBlocksForUndo.set(x, y, z, block);
                    changeCount.incrementAndGet();
                }
            });
            String countString = NumberFormat.getInstance().format(changeCount.get());
            String historyDescription = AxiomI18n.get("axiom.history_description.deleted", countString);
            Dispatcher.push(new HistoryEntry<BlockOrBiomeBuffer>(setOperation, previousBlocksForUndo, this.selectionRegion.getCenter(), historyDescription, HistoryEntry.MODIFIER_SELECT_ON_BACKSTEP), Dispatcher.simpleSourceInfo("Selection Delete"));
        }

        @Override
        public CompletableFuture<CopyResult> callCopy(boolean cut, boolean copyAir) {
            class_638 world = class_310.method_1551().field_1687;
            if (world == null) {
                return CompletableFuture.completedFuture(null);
            }
            class_2338 offset = this.center();
            BlockBuffer forwards = cut ? new BlockBuffer() : null;
            BlockBuffer backwards = cut ? new BlockBuffer() : null;
            IntWrapper changeCount = cut ? new IntWrapper() : null;
            class_2680 air = class_2246.field_10124.method_9564();
            LongOpenHashSet needNbt = new LongOpenHashSet();
            LongOpenHashSet needChunks = new LongOpenHashSet();
            ChunkedBlockRegion blockBuffer = new ChunkedBlockRegion();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Long2ObjectOpenHashMap loadedNbt = new Long2ObjectOpenHashMap();
            class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
            Long2ObjectOpenHashMap containers = new Long2ObjectOpenHashMap();
            PositionSet positionSet = this.selectionRegion.unsafeGetPositionSet();
            ServerConfig serverConfig = Axiom.getInstance().serverConfig;
            LongIterator longIterator = positionSet.chunkKeySet().longIterator();
            while (longIterator.hasNext()) {
                long pos = longIterator.nextLong();
                int cx = class_2338.method_10061((long)pos);
                int cy = class_2338.method_10071((long)pos);
                int cz = class_2338.method_10083((long)pos);
                int sectionIndex = world.method_31603(cy);
                if (sectionIndex < 0 || sectionIndex >= world.method_32890()) continue;
                class_2818 chunk = (class_2818)world.method_8402(cx, cz, class_2806.field_12803, false);
                if (chunk == null) {
                    needChunks.add(pos);
                    continue;
                }
                class_2826 section = chunk.method_38259(sectionIndex);
                if (section.method_38292()) continue;
                containers.put(pos, (Object)section.method_12265());
            }
            containers.forEach((arg_0, arg_1) -> Set.lambda$callCopy$5(positionSet, offset, copyAir, cut, forwards, air, backwards, changeCount, blockBuffer, serverConfig, (LongSet)needNbt, world, mutableBlockPos, baos, (Long2ObjectMap)loadedNbt, arg_0, arg_1));
            if (needNbt.isEmpty() && needChunks.isEmpty()) {
                if (cut) {
                    String countString = NumberFormat.getInstance().format(changeCount.value);
                    String historyDescription = AxiomI18n.get("axiom.history_description.cut", countString);
                    Dispatcher.push(new HistoryEntry<BlockOrBiomeBuffer>(forwards, backwards, offset, historyDescription, HistoryEntry.MODIFIER_CUT | HistoryEntry.MODIFIER_SELECT_ON_BACKSTEP), Dispatcher.simpleSourceInfo("Selection Cut"));
                }
                return CompletableFuture.completedFuture(new CopyResult(blockBuffer, (Long2ObjectMap<CompressedBlockEntity>)loadedNbt));
            }
            PositionSet positionSetCopied = positionSet.copy();
            CompletableFuture<CopyResult> future = new CompletableFuture<CopyResult>();
            Dispatcher.requestChunkData((LongSet)needNbt, (LongSet)needChunks, true, (arg_0, arg_1) -> Set.lambda$callCopy$8(positionSetCopied, offset, copyAir, cut, forwards, air, backwards, changeCount, blockBuffer, (Long2ObjectMap)loadedNbt, future, arg_0, arg_1));
            return future;
        }

        @Override
        public void forEach(TriIntConsumer consumer) {
            this.selectionRegion.forEach(consumer);
        }

        @Override
        public void render(class_4184 camera, long time, class_4587 matrices, Matrix4f projection, int effects) {
            this.selectionRegion.render(camera, class_243.field_1353, matrices, projection, time, effects);
        }

        @Override
        public SelectionBuffer optimize() {
            if (this.selectionRegion.count() <= 0) {
                this.close();
                return EMPTY;
            }
            if (this.selectionRegion.count() > 0) {
                class_2338 max2 = this.selectionRegion.max();
                class_2338 min2 = this.selectionRegion.min();
                int volume = (max2.method_10263() - min2.method_10263() + 1) * (max2.method_10264() - min2.method_10264() + 1) * (max2.method_10260() - min2.method_10260() + 1);
                if (volume <= this.selectionRegion.count()) {
                    AABB aabb = new AABB(this.selectionRegion.min(), this.selectionRegion.max());
                    this.close();
                    return aabb;
                }
            }
            return this;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Set that = (Set)obj;
            return Objects.equals(this.selectionRegion, that.selectionRegion);
        }

        public int hashCode() {
            return Objects.hash(this.selectionRegion);
        }

        private static /* synthetic */ void lambda$callCopy$8(PositionSet positionSetCopied, class_2338 offset, boolean copyAir, boolean cut, BlockBuffer forwards, class_2680 air, BlockBuffer backwards, IntWrapper changeCount, ChunkedBlockRegion blockBuffer, Long2ObjectMap loadedNbt, CompletableFuture future, Long2ObjectMap compressedBlockEntities, Long2ObjectMap chunkSections) {
            chunkSections.forEach((pos, container) -> {
                if (container == null) {
                    return;
                }
                short[] array = positionSetCopied.getChunk((long)pos);
                if (array == null) {
                    return;
                }
                int wcx = class_2338.method_10061((long)pos) * 16;
                int wcy = class_2338.method_10071((long)pos) * 16;
                int wcz = class_2338.method_10083((long)pos) * 16;
                int offsetX = wcx - offset.method_10263();
                int offsetY = wcy - offset.method_10264();
                int offsetZ = wcz - offset.method_10260();
                int index = 0;
                for (int z = 0; z < 16; ++z) {
                    for (int y = 0; y < 16; ++y) {
                        short v;
                        if ((v = array[index++]) == 0) continue;
                        for (int x = 0; x < 16; ++x) {
                            if ((v & 1 << x) == 0) continue;
                            class_2680 blockState = (class_2680)container.method_12321(x, y, z);
                            if (!copyAir && blockState.method_26215()) continue;
                            if (cut) {
                                forwards.set(x + wcx, y + wcy, z + wcz, air);
                                backwards.set(x + wcx, y + wcy, z + wcz, blockState);
                                ++changeCount.value;
                            }
                            blockBuffer.addBlock(x + offsetX, y + offsetY, z + offsetZ, blockState);
                        }
                    }
                }
            });
            compressedBlockEntities.forEach((pos, compressedBlockEntity) -> {
                int x = class_2338.method_10061((long)pos);
                int y = class_2338.method_10071((long)pos);
                int z = class_2338.method_10083((long)pos);
                int xo = x - offset.method_10263();
                int yo = y - offset.method_10264();
                int zo = z - offset.method_10260();
                if (cut) {
                    backwards.putBlockEntity(x, y, z, (CompressedBlockEntity)compressedBlockEntity);
                }
                loadedNbt.put(class_2338.method_10064((int)xo, (int)yo, (int)zo), compressedBlockEntity);
            });
            if (cut) {
                String countString = NumberFormat.getInstance().format(changeCount.value);
                String historyDescription = AxiomI18n.get("axiom.history_description.cut", countString);
                Dispatcher.push(new HistoryEntry<BlockOrBiomeBuffer>(forwards, backwards, offset, historyDescription, HistoryEntry.MODIFIER_CUT | HistoryEntry.MODIFIER_SELECT_ON_BACKSTEP), Dispatcher.simpleSourceInfo("Selection Cut"));
            }
            future.complete(new CopyResult(blockBuffer, (Long2ObjectMap<CompressedBlockEntity>)loadedNbt));
        }

        private static /* synthetic */ void lambda$callCopy$5(PositionSet positionSet, class_2338 offset, boolean copyAir, boolean cut, BlockBuffer forwards, class_2680 air, BlockBuffer backwards, IntWrapper changeCount, ChunkedBlockRegion blockBuffer, ServerConfig serverConfig, LongSet needNbt, class_638 world, class_2338.class_2339 mutableBlockPos, ByteArrayOutputStream baos, Long2ObjectMap loadedNbt, Long pos, class_2841 container) {
            short[] array = positionSet.getChunk(pos);
            if (array == null) {
                return;
            }
            int wcx = class_2338.method_10061((long)pos) * 16;
            int wcy = class_2338.method_10071((long)pos) * 16;
            int wcz = class_2338.method_10083((long)pos) * 16;
            int offsetX = wcx - offset.method_10263();
            int offsetY = wcy - offset.method_10264();
            int offsetZ = wcz - offset.method_10260();
            int index = 0;
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 16; ++y) {
                    short v;
                    if ((v = array[index++]) == 0) continue;
                    for (int x = 0; x < 16; ++x) {
                        class_2586 blockEntity;
                        if ((v & 1 << x) == 0) continue;
                        class_2680 blockState = (class_2680)container.method_12321(x, y, z);
                        if (!copyAir && blockState.method_26215()) continue;
                        if (cut) {
                            forwards.set(x + wcx, y + wcy, z + wcz, air);
                            backwards.set(x + wcx, y + wcy, z + wcz, blockState);
                            ++changeCount.value;
                        }
                        blockBuffer.addBlock(x + offsetX, y + offsetY, z + offsetZ, blockState);
                        if (serverConfig.blocksWithCustomData().contains(blockState.method_26204())) {
                            needNbt.add(class_2338.method_10064((int)(x + wcx), (int)(y + wcy), (int)(z + wcz)));
                            continue;
                        }
                        if (!blockState.method_31709() || (blockEntity = world.method_8321((class_2338)mutableBlockPos.method_10103(x + wcx, y + wcy, z + wcz))) == null) continue;
                        class_2487 nbt = ClientBlockEntitySerializer.serialize(blockEntity, (class_7225.class_7874)world.method_30349());
                        if (nbt != null) {
                            if (nbt.method_33133()) continue;
                            CompressedBlockEntity compressedBlockEntity = CompressedBlockEntity.compress(nbt, baos);
                            long blockEntityPos = class_2338.method_10064((int)(x + offsetX), (int)(y + offsetY), (int)(z + offsetZ));
                            if (cut) {
                                backwards.putBlockEntity(x + wcx, y + wcy, z + wcz, compressedBlockEntity);
                            }
                            loadedNbt.put(blockEntityPos, (Object)compressedBlockEntity);
                            continue;
                        }
                        needNbt.add(mutableBlockPos.method_10063());
                    }
                }
            }
        }
    }

    public record CopyResult(ChunkedBlockRegion chunkedBlockRegion, Long2ObjectMap<CompressedBlockEntity> blockEntities) {
    }
}

